﻿<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Prosta lista płac</title>
		<script runat="server">

            Wyplata wypłata;
            Currency sumGotowka, sumRor;

            void Grid_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
                wypłata = (Wyplata)args.Row;
                decimal doOpodatk = 0, nieOpodatk = 0;

                colNazImie.EditValue = string.Format("<strong>{0}</strong> {1}",
                    wypłata.PracHistoria.Nazwisko, wypłata.PracHistoria.Imie);

                foreach (WypElement element in wypłata.ElementyWgKolejności) {
                    doOpodatk += element.DoOpodatkowania;
                    nieOpodatk += element.NiePodlegaOpodatkowaniu;
                }
                colSumaOpodatk.EditValue = doOpodatk;
                colSumaNieopodatk.EditValue = nieOpodatk;
                sumGotowka += wypłata.Gotówka;
                sumRor += wypłata.Inne;
            }

            void Grid_AfterRender(object sender, System.EventArgs e) {
                if (wypłata==null) return;

                decimal suma = (decimal)colSumaOpodatk.GetTotalValue(0m) + (decimal)colSumaNieopodatk.GetTotalValue(0m); 
                cellSuma.EditValue = (Currency)suma;
            
                Currency gotówka = wypłata.Gotówka; //(Currency)colGotowka.GetTotalValue(0m);
                Currency ror = wypłata.Inne; //(Currency)colROR.GetTotalValue(0m);
                cellNetto.EditValue = sumGotowka + sumRor;
            }

            public class SrParams : SerializableContextBase {
                public SrParams(Context context) : base(context) {
                }

                //static bool hideOperator = false;
                bool hideOperator = false;
                [Priority(1)]
                [Caption("Ukryj operatora")]
                public bool HideOperator {
                    get { return hideOperator; }
                    set {
                        hideOperator = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                //static bool nazwaWNaglowku = false;
                bool nazwaWNaglowku = false;
                [Priority(2)]
                [Caption("Nazwa w nagłówku")]
                public bool NazwaWNaglowku {
                    get { return nazwaWNaglowku; }
                    set {
                        nazwaWNaglowku = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            SrParams srpars;
            [SettingsContext]
            public SrParams SrPars
            {
                get { return srpars; }
                set { srpars = value; }
            }		

            private bool JestPPK(ISessionable session, Date data) {
        YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
        return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).Contains(data) : false;
     }

            void dc_ContextLoad(Object sender, EventArgs e) {
                ListaPlac lista = (ListaPlac)dc[typeof(ListaPlac)];
                if (lista.Bufor)
                    ReportHeader1["BUFOR"] = "Lista nie została zatwierdzona!|";
                else
                    ReportHeader1["BUFOR"] = "";

                if (srpars.NazwaWNaglowku)
                    ReportHeader1["NAZWA"] = lista.Definicja.Nazwa + "|";
                else
                    ReportHeader1["NAZWA"] = "";

                if (srpars.HideOperator)
                    stOperator.SubtitleType = SubtitleType.Empty;

                if (lista.Definicja.WalutaPlatnosci != null && lista.Definicja.WalutaPlatnosci.Symbol != Currency.SystemSymbol) {
                    colROR.Format = "";
                    colGotowka.Format = "";
                }

                colPPKF.Visible = colPPKP.Visible = JestPPK(lista, lista.DataWyplaty);
            }

            static void Msg(object value) {
            }
		    
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ProstaListaPłac" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" RightMargin="-1" LeftMargin="-1" TypeName="Soneta.Place.ListaPlac, Soneta.KadryPlace"
				OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Lista płac {0}|%NAZWA%%BUFOR%</strong>Wydział:<strong> {1}|</strong>Za okres:<strong> {2}|</strong>Data wypłaty:<strong> {3}"
				runat="server" DataMember2="Okres" DataMember1="Wydzial" DataMember0="Numer" DataMember3="DataWyplaty"></cc1:reportheader>
			<ea:Grid id="Grid" runat="server" onafterrender="Grid_AfterRender" onbeforerow="Grid_BeforeRow"
				DataMember="Wyplaty" RowTypeName="Soneta.Place.Wyplata, Soneta.KadryPlace">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="Numer.Numer" Caption="Lp" VAlign="Top" runat="server"></ea:GridColumn>
					<ea:GridColumn Total="Info" Caption="Nazwisko i imię" ID="colNazImie" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" Total="Sum" Caption="Elementy~opodatk."
						Format="{0:n}" ID="colSumaOpodatk" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" Total="Sum" Caption="Elementy~nieopodatk."
						Format="{0:n}" ID="colSumaNieopodatk" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="Workers.WyplataSkładki.Razem.KosztyZUS" Total="Sum"
						Caption="Składki|ZUS" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="Workers.PITInfo.ZalFIS" Total="Sum" Caption="Zaliczka|podatku"
						Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Prac"
						Total="Sum" Caption="Składka|zdrowotna" Format="{0:n}" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Składki PPK~pracodaw."
						Format="{0:n}" runat="server" DataMember="Workers.PPK.Pracodawcy" ID="colPPKF"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Składki PPK~uczest."
						Format="{0:n}" runat="server" DataMember="Workers.PPK.Pracownika" ID="colPPKP"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Do wypłaty~got&#243;wka"
						Format="{0:n}" ID="colGotowka" runat="server" DataMember="Got&#243;wka"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" Total="Sum" Caption="Do wypłaty~ROR"
						Format="{0:n}" ID="colROR" runat="server" DataMember="Inne"></ea:GridColumn>
					<ea:GridColumn Align="Right" Caption="Data|podpis" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:reportfooter id="ReportFooter1" runat="server">
				<Cells>
					<cc1:FooterCell Caption="Suma wypłat:" Format1="{0:u}," ID="cellSuma"></cc1:FooterCell>
					<cc1:FooterCell Caption="Do wypłaty (netto):" Format1="{0:u}," ID="cellNetto"></cc1:FooterCell>
				</Cells>
				<Subtitles>
					<cc1:FooterSubtitle Caption="Sprawdzono pod względem merytorycznym" SubtitleType="DataPodpis" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdzono pod względem formalno prawnym" SubtitleType="DataPodpis" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle ID="stOperator" SubtitleType="Operator"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="data"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="gł&#243;wny księgowy"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="kierownik jednostki"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
		</form>
	</body>
</HTML>
